export interface TwirpErrorJSON {
  code: string;
  msg: string;
  meta: { [key: string]: string };
}

export class TwirpError extends Error {
  public code: string;
  public meta: { [index: string]: string };

  constructor(te: TwirpErrorJSON) {
    super(te.msg);

    this.code = te.code;
    this.meta = te.meta;
  }
}

// tslint:disable-next-line:max-classes-per-file
export class TwirpResponse<T> {
  public data: T;
  public error?: TwirpError;
}

export const throwTwirpError = (resp: Response) => {
  return resp.json().then((err: TwirpErrorJSON) => {
    throw new TwirpError(err);
  });
};

export const createTwirpRequest = (url: string, body: object): Request => {
  return new Request(url, {
    method: 'POST',
    headers: {
      Accept: 'application/json',
      'Content-Type': 'application/json',
    },
    body: JSON.stringify(body),
  });
};

export type Fetch = (input: RequestInfo, init?: RequestInit) => Promise<Response>;
