import * as React from 'react';
import {
  Background,
  BorderRadius,
  Button,
  ButtonType,
  Layout,
  Position,
  StyledLayout,
  VerticalAlign,
  ZIndex,
} from 'twitch-core-ui';
import { ClickOutDetector } from 'vienna/common/components';

interface Props {
  label: string;
  show?: boolean;
}

interface State {
  show: boolean;
}

// Button with a dropdown icon. If clicked, shows a popup with more details.
// Example: <DetailsPopup label="Show More"><p>Here is More<\p></DetailsPopup>
export class DetailsPopup extends React.Component<Props, State> {
  public state: State = {
    show: false,
  };

  constructor(props: Props) {
    super(props);
    this.state = {
      show: props.show || false,
    };
  }

  public render() {
    return (
      <Layout position={Position.Relative}>
        <Button onClick={this.showPopup} type={ButtonType.Hollow} dropdown>
          {this.props.label}
        </Button>
        {this.state.show && (
          <ClickOutDetector onClickOut={this.closePopup}>
            <StyledLayout
              background={Background.Base}
              border
              borderRadius={BorderRadius.Medium}
              elevation={1}
              padding={1}
              position={Position.Absolute}
              zIndex={ZIndex.Above}
            >
              {this.props.children}
            </StyledLayout>
          </ClickOutDetector>
        )}
      </Layout>
    );
  }

  private showPopup = () => {
    this.setState({ show: true });
  };
  private closePopup = () => {
    this.setState({ show: false });
  };
}
