import * as React from 'react';
import { connect, Dispatch } from 'react-redux';
import { Action } from 'redux';
import { closeModal } from 'vienna/core/actions/modal';
import { ModalCloserComponent, PublicProps, ReduxDispatchProps } from './component';

interface ContainerPublicProps {
  /**
   * An optional callback that will be invoked when the ModalCloser causes the modal to be closed.
   */
  onClose?: () => void;
}

export type Props = ContainerPublicProps & PublicProps;

export function mapDispatchToProps(dispatch: Dispatch<Action>, ownProps: Props): ReduxDispatchProps {
  return {
    onClose: () => {
      // Invoke this first so that the mounted modal still can execute cleanup logic before we tear the modal down
      if (ownProps.onClose) {
        ownProps.onClose();
      }

      dispatch(closeModal());
    },
  };
}

export const ModalCloser: React.ComponentClass<Props> = connect(
  null,
  mapDispatchToProps,
)(ModalCloserComponent);
