import * as React from 'react';
import * as Modal from 'react-modal';
import './styles.sass';

let modalRoot: ModalRootComponent | null = null;

export interface ReduxStateProps {
  showModal: boolean;
  component: React.ComponentClass<{}> | null;
  componentProps: {} | null;
}

type Props = ReduxStateProps;

interface State {
  isError: boolean;
}

/**
 * Used in combination with modal-closer component to handle
 * closing on backdrop click
 */
export const backdropClassName = 'js-modal-backdrop';

/**
 * The top-level hosting component that lives at the root of the app
 * which renders any modal that happens to be in redux state.
 */
export class ModalRootComponent extends React.Component<Props, State> {
  public state = {
    isError: false,
  };

  constructor(props: Props) {
    super(props);

    if (modalRoot) {
      // tslint:disable-next-line:no-console
      console.log('There should only be one ModalRoot component mounted at a time. ModalRoot is already mounted.');
    }

    modalRoot = this;
  }

  public componentWillUnmount() {
    modalRoot = null;
  }

  public componentDidCatch(error: Error, info: React.ErrorInfo) {
    this.setState({ isError: true }, () => {
      // tslint:disable-next-line:no-console
      console.log(error, 'A unhandled exception occurred in the component hierarchy', { info });
    });
  }

  public render() {
    if (this.state.isError) {
      return null;
    }

    return (
      <Modal
        isOpen={this.props.showModal}
        contentLabel="Modal"
        className="modal__content"
        overlayClassName={`modal__backdrop ${backdropClassName}`}
        shouldCloseOnOverlayClick={false}
      >
        {this.props.component && <this.props.component {...this.props.componentProps} />}
      </Modal>
    );
  }
}
