import { connect } from 'react-redux';
import { GlobalState } from 'vienna/common/models/global-state';
import { getModalComponent } from 'vienna/core/state/modal';
import { ModalRootComponent, ReduxStateProps } from './component';

export function mapStateToProps(state: GlobalState): ReduxStateProps {
  return {
    showModal: state.modal.show,
    component: state.modal.modalID ? getModalComponent(state) : null,
    componentProps: state.modal.modalProps,
  };
}

export const ModalRoot = connect(mapStateToProps)(ModalRootComponent);
