import * as React from 'react';
import { Color, CoreText, FontSize, Layout } from 'twitch-core-ui';

interface Props {
  title: string;
  subtitle?: string;
}

export const PageHeading = (props: Props) => {
  return (
    <Layout padding={{ bottom: 2 }}>
      <CoreText fontSize={FontSize.Size2} bold>
        {props.title}
      </CoreText>
      {props.subtitle && (
        <CoreText color={Color.Alt2} fontSize={FontSize.Size5}>
          {props.subtitle}
        </CoreText>
      )}
    </Layout>
  );
};
