import * as React from 'react';
import { AlertBanner, AlertBannerType, Display, Margin, Padding, StyledLayout } from 'twitch-core-ui';

interface Props {
  message?: string; // Success message. If null or empty, the component renders nothing.
  margin?: Margin;
  padding?: Padding;
}

export class SuccessMessage extends React.Component<Props> {
  public render() {
    if (!this.props.message) {
      return null;
    }

    return (
      <StyledLayout display={Display.Block} margin={this.props.margin} padding={this.props.padding}>
        <AlertBanner
          type={AlertBannerType.Success}
          status="Success"
          message={this.props.message!}
          closeButtonAriaLabel="close"
          onCloseButtonClick={this.onCloseButtonClick}
        />
      </StyledLayout>
    );
  }

  private onCloseButtonClick = () => {
    return true;
  };
}
