import { convertDateFormat } from './date';

describe('Date Util', () => {
  it('expect basic conversion to be correct', () => {
    const result = convertDateFormat('2018-10-24T15:15:00Z');
    expect(result).toEqual('2018/10/24');
  });
  it('expect single months and single dates to pad with 0s', () => {
    const result = convertDateFormat('2018-02-01T15:15:00Z');
    expect(result).toEqual('2018/02/01');
  });
  it('expect January to convert correctly', () => {
    const result = convertDateFormat('2018-01-24T15:15:00Z');
    expect(result).toEqual('2018/01/24');
  });
  it('expect December to convert correctly', () => {
    const result = convertDateFormat('2018-12-24T15:15:00Z');
    expect(result).toEqual('2018/12/24');
  });
  it('expect bad date to return "bad date format"', () => {
    const result = convertDateFormat('2018-00-24T15:15:00Z');
    expect(result).toEqual('bad date format');
  });
  it('expect empty input to return empty string', () => {
    const result = convertDateFormat('');
    expect(result).toEqual('');
  });
});
