export function convertDateFormat(timestamp: string): string {
  if (!timestamp) {
    return '';
  }

  const date = new Date(timestamp);

  const day = date.getDate();
  const year = date.getFullYear();
  const month = date.getMonth() + 1;
  const dayStr = day < 10 ? `0${day}` : day;
  const monthStr = month < 10 ? `0${month}` : month;
  const formattedStr = `${year}/${monthStr}/${dayStr}`;

  if (formattedStr.indexOf('NaN') !== -1) {
    return 'bad date format';
  }

  return formattedStr;
}
