import { formatLink } from './link';

describe('Link Util', () => {
  it('expect http to be added when missing', () => {
    const result = formatLink('google.com');
    expect(result).toEqual('http://google.com');
  });
  it('expect string to stay the same when https present', () => {
    const result = formatLink('https://google.com');
    expect(result).toEqual('https://google.com');
  });
  it('expect string to stay the same when http present', () => {
    const result = formatLink('http://google.com');
    expect(result).toEqual('http://google.com');
  });
});
