import { ComponentClass } from 'react';
import { Action } from 'vienna/common/models/actions';

export const MODAL_SHOWN = 'core.modal.MODAL_SHOWN';
export interface ModalShown extends Action<typeof MODAL_SHOWN> {
  modalComponent: ComponentClass<{}>;
  modalProps: {};
}

// use these types in your component after they are wrapped in dispatch
export type ShowModalWithDispatch = <P>(component: ComponentClass<P>, props: P) => void;
export type CloseModalWithDispatch = () => void;

/**
 * Call this to display a component in a modal overlay on top of the rest
 * of the page, such as the login or report forms.
 * @param component The component class to be displayed in the modal
 * @param props Props to provide to the given component when it is mounted
 */
export function showModal<P>(component: ComponentClass<P>, props: P): ModalShown {
  return {
    type: MODAL_SHOWN,
    modalComponent: component,
    modalProps: props,
  };
}

export const MODAL_CLOSED = 'core.ui.MODAL_CLOSED';
export interface ModalClosed extends Action<typeof MODAL_CLOSED> {}

/**
 * Closes any modal that is being displayed on top of the page.
 */
export function closeModal(): ModalClosed {
  return {
    type: MODAL_CLOSED,
  };
}

export type All = ModalShown | ModalClosed;
