import { Action } from 'vienna/common/models/actions';
import { SessionUser } from 'vienna/core/models/session-user';

export const AUTH_INITIALIZED = 'core.session.AUTH_INITIALIZED';
export const INITIALIZED = 'core.session.INITIALIZED';
export const FIRST_PAGE_LOADED = 'core.session.FIRST_PAGE_LOADED';
export const LOGIN_SUCCESS = 'core.session.LOGIN_SUCCESS';
export const LOGOUT = 'core.session.LOGOUT';

interface AuthInitialized extends Action<typeof AUTH_INITIALIZED> {
  user?: SessionUser;
}
interface Initialized extends Action<typeof INITIALIZED> {}
interface FirstPageLoaded extends Action<typeof FIRST_PAGE_LOADED> {}

export type All = Initialized | FirstPageLoaded | AuthInitialized;

export function initialize() {
  return {
    type: INITIALIZED,
  };
}

export function firstPageLoaded(): FirstPageLoaded {
  return {
    type: FIRST_PAGE_LOADED,
  };
}

export function initializeAuth(user: SessionUser | null): AuthInitialized {
  return {
    type: AUTH_INITIALIZED,
    user: user || undefined,
  };
}
