import * as Cookies from 'js-cookie';
import { config, vienna } from 'vienna';
import { fetchWithAuth } from 'vienna/common/api/fetch-with-auth';
import { initializeAuth } from 'vienna/core/actions/session';

export function login() {
  return 'login';
}

export function home() {
  return '/';
}

const AUTH_COOKIE_NAME = 'vienna_access_token';

export function setAuthCookie(token: string) {
  Cookies.set(AUTH_COOKIE_NAME, token);
}

export async function authenticateUserFromAuthCookie(): Promise<string> {
  const authToken = Cookies.get(AUTH_COOKIE_NAME);
  if (!authToken) {
    vienna.store.dispatch(initializeAuth(null));
    return login();
  }

  // Validate auth token
  const resp = await fetchWithAuth('https://id.twitch.tv/oauth2/validate', {
    headers: {
      Authorization: `OAuth ${authToken}`,
    },
  });
  if (!resp.ok) {
    vienna.store.dispatch(initializeAuth(null));
    return login();
  }

  // Set session user
  const respData = await resp.json();
  vienna.store.dispatch(
    initializeAuth({
      authToken,
      id: respData.userId,
      login: respData.login,
    }),
  );

  return home();
}

export async function revokeUser() {
  const authToken = Cookies.get(AUTH_COOKIE_NAME);
  if (!authToken) {
    return login();
  }

  const url =
    'https://id.twitch.tv/oauth2/revoke' +
    `?client_id=${encodeURIComponent(config.twitchClientId)}` +
    `&token=${authToken}`;
  const resp = await fetch(url, { method: 'POST' });

  if (!resp.ok) {
    // tslint:disable-next-line:no-console
    console.log('bad request. is client id right?');
  }

  Cookies.remove(AUTH_COOKIE_NAME);

  await vienna.store.dispatch(initializeAuth(null));

  return login();
}
