/**
 *  Entry point for standalone vienna.
 */
import * as React from 'react';
import { Provider } from 'react-redux';
import { Router } from 'react-router';
import { vienna } from 'vienna';
import { initialize } from 'vienna/core/actions/session';
import { authenticateUserFromAuthCookie } from 'vienna/core/auth/authenticate-user';
import { sessionInitialized } from 'vienna/core/state/session';
import { Root } from 'vienna/pages/root';

function mount() {
  vienna.mount(
    <Provider store={vienna.store.getReduxStore()}>
      <Router history={vienna.history}>
        <React.Fragment>
          <Root />
        </React.Fragment>
      </Router>
    </Provider>,
    document.getElementById('root')!,
  );
}

let mountUnsubscriber: () => void;
let initialized = false;

function mountSubscriber() {
  const state = vienna.store.getState();
  if (!initialized && sessionInitialized(state)) {
    initialized = true;
    mountUnsubscriber();
    mount();
  }
}

mountUnsubscriber = vienna.store.getReduxStore().subscribe(mountSubscriber);

authenticateUserFromAuthCookie();
vienna.store.dispatch(initialize());
