import { createBrowserHistory } from 'history';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { Config } from 'vienna/common/config';
import { ViennaStore } from 'vienna/core/vienna-store';
import './styles.scss';

export let vienna: Vienna;
export let config: Config;
export let store: typeof vienna.store;

export function initVienna(configuration: Config) {
  vienna = new Vienna(configuration);
}

export class Vienna {
  public config: Config;
  public store: ViennaStore;
  public history = createBrowserHistory();
  constructor(configuration: Config) {
    this.config = configuration;
    config = configuration;
    this.store = new ViennaStore(this.config);
  }

  public mount(element: JSX.Element, rootElement: HTMLElement) {
    ReactDOM.render(element, rootElement);
  }

  public wrap(element: JSX.Element) {
    return <Provider store={this.store.getReduxStore()}>{element}</Provider>;
  }
}

// Returns true if the build is running in localhost, even if it is a staging/production build.
export function runningInLocalhost() {
  const h = location.hostname;
  return h === 'localhost' || h === '127.0.0.1' || h === '';
}
