import { RBACActionHistoryMock } from 'vienna/common/clients/rbacrpcMock';
const ahMock = new RBACActionHistoryMock();
jest.doMock('vienna/common/clients/rbacClient', () => ({
  ActionHistory: ahMock,
}));

import { Props, TestSelectors, ActivityLogModalComponent } from './component';
import { setupShallowTest } from 'vienna/tests/utils/setup';
import { pause } from 'vienna/tests/utils/pause';

describe('CompanyApplicationDirectory', () => {
  it('renders single action', async () => {
    ahMock.listActionHistoriesMock.mockResolvedValue({
      data: {
        actionhistories: [
          {
            id: 'uuid-fdsfads-fdsafds',
            action: 'Created some stuff in company X',
            userTwitchId: '123',
            createdat: '',
            entityId: '',
            entityType: '',
          },
        ],
        total: 1,
      },
    });

    const { wrapper } = setupShallowTest<Props, {}>(
      ActivityLogModalComponent,
      (): Props => ({
        closeModal: jest.fn(),
        title: 'asdf',
      }),
    )();

    await pause();

    const body = wrapper.find({ 'data-test-selector': TestSelectors.ACTIVITY_TABLE_BODY });
    expect(body.children().length).toBe(1);

    const name = wrapper.find({ 'data-test-selector': TestSelectors.ACTIVITY_ROW_NAME });
    expect(name.prop('children')).toBe('123');
  });
});
