import * as React from 'react';
import { Button, Layout } from 'twitch-core-ui';
import { RBAC } from 'vienna/common/clients/rbacClient';
import { CreateCompanyApplicationRequest } from 'vienna/common/clients/rbacrpc';
import { ModalShown } from 'vienna/core/actions/modal';
import { PublicProps as AddCompanyModalProps } from 'vienna/features/add-company/components/add-company-modal';

export interface PublicProps {
  onCompanyAdded: () => void;
}

export interface ReduxDispatchProps {
  showAddCompanyModal: (props: AddCompanyModalProps) => ModalShown;
}

type Props = PublicProps & ReduxDispatchProps;

export interface State {}

export class AddCompanyComponent extends React.Component<Props, State> {
  public state: State = {};

  public render() {
    return (
      <Layout>
        <Button onClick={this.onClick}>Add Company</Button>
      </Layout>
    );
  }

  private onModalSubmit = async (companyApp: CreateCompanyApplicationRequest): Promise<string> => {
    const { error: createAppError, data: app } = await RBAC.createCompanyApplication(companyApp);
    if (createAppError) {
      return `error creating company application: ${createAppError}`;
    }

    const { error: onboardError } = await RBAC.onboardCompany({
      id: app.id,
    });
    if (onboardError) {
      const { error: deleteError } = await RBAC.deleteCompanyApplication({
        id: app.id,
        skipEmail: true,
      });

      if (deleteError) {
        return `error approving company application, could not rollback: ${deleteError}`;
      }

      return `error approving company application: ${onboardError}`;
    }
    this.props.onCompanyAdded();
    return '';
  };

  private onClick = () => {
    this.props.showAddCompanyModal({
      onSubmit: this.onModalSubmit,
    });
  };
}
