import { connect } from 'react-redux';
import { Action, bindActionCreators, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { AddCompanyModal } from 'vienna/features/add-company/components/add-company-modal';
import { AddCompanyComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showAddCompanyModal: ({ ...props }) => showModal(AddCompanyModal, props),
    },
    dispatch,
  );
}

export const AddCompany: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(AddCompanyComponent);
