import * as React from 'react';
import { Button, Layout } from 'twitch-core-ui';
import { Modal } from 'vienna/common/components';
import { GamesSearchAutocomplete } from 'vienna/features/games-autocomplete';
import { Game } from 'vienna/features/games-autocomplete/models/game';

export interface PublicProps {
  onSubmit: (gameID: number) => Promise<string>;
}

export interface ReduxDispatchProps {
  closeModal: () => void;
}

type Props = PublicProps & ReduxDispatchProps;

export interface State {
  selectedGameID: number;
  errorMessage: string;
  success: boolean;
}

export class AddGameModal extends React.Component<Props, State> {
  public state: State = {
    selectedGameID: -1,
    errorMessage: '',
    success: false,
  };

  public render() {
    return (
      <Modal errorMessage={this.state.errorMessage}>
        <Layout margin={1}>Add a game</Layout>
        <Layout>
          <GamesSearchAutocomplete multi={false} onGameSelect={this.onGameSelect} excludeOwnedGames={true} />
          <Button disabled={this.state.success} onClick={this.onSubmit}>
            Submit
          </Button>
        </Layout>
      </Modal>
    );
  }

  private onGameSelect = (games: Game[]) => {
    if (games.length === 0) {
      return;
    }

    this.setState({
      success: false,
      selectedGameID: games[0]._id,
    });
  };

  private onSubmit = async () => {
    const result = await this.props.onSubmit(this.state.selectedGameID);
    if (result !== '') {
      this.setState({
        errorMessage: result,
      });
    } else {
      this.setState({
        success: true,
      });
    }
  };
}
