import * as React from 'react';
import { Button, Layout } from 'twitch-core-ui';
import { RBAC } from 'vienna/common/clients/rbacClient';
import { GameApplication } from 'vienna/common/clients/rbacrpc';
import { ModalShown } from 'vienna/core/actions/modal';
import { config, vienna } from 'vienna/core/vienna';
import { PublicProps as AddGameModalProps } from 'vienna/features/add-game/components/add-game-modal';

export interface PublicProps {
  companyId: string;
  onGameAdded: () => void;
}

export interface ReduxDispatchProps {
  showAddGameModal: (props: AddGameModalProps) => ModalShown;
}

type Props = PublicProps & ReduxDispatchProps;

export interface State {}

export class AddGameComponent extends React.Component<Props, State> {
  public state: State = {};

  public render() {
    return (
      <Layout>
        <Button onClick={this.onClick}>Add Game</Button>
      </Layout>
    );
  }

  private onModalSubmit = async (gameID: number): Promise<string> => {
    const { error: appError, data: app } = await RBAC.createGameApplication({
      gameId: gameID,
      companyId: this.props.companyId,
    });
    if (appError) {
      return `error creating game application: ${appError}`;
    }

    const { error: onboardError } = await RBAC.onboardGame({
      gameApplicationId: app.id,
    });
    if (onboardError) {
      const { error: deleteError } = await RBAC.deleteGameApplication({
        id: app.id,
        skipEmail: true,
      });
      if (deleteError) {
        return `error approving game application ${app.id}: ${deleteError}`;
      }

      return `error approving game application: ${onboardError}.`;
    }

    this.props.onGameAdded();
    return '';
  };

  private onClick = () => {
    this.props.showAddGameModal({
      onSubmit: this.onModalSubmit,
    });
  };
}
