import { connect } from 'react-redux';
import { Action, bindActionCreators, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { AddGameModal } from 'vienna/features/add-game/components/add-game-modal';
import { AddGameComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showAddGameModal: ({ ...props }) => showModal(AddGameModal, props),
    },
    dispatch,
  );
}

export const AddGame: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(AddGameComponent);
