import { connect, Dispatch } from 'react-redux';
import { bindActionCreators } from 'redux';
import { GlobalState } from 'vienna/common/models/global-state';
import { showModal } from 'vienna/core/actions/modal';
import { ManageUserModal } from 'vienna/features/manage-user';
import { AddUserComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<GlobalState>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showManageUserModal: ({ ...props }) => showModal(ManageUserModal, props),
    },
    dispatch,
  );
}

export const AddUser = connect(
  null,
  mapDispatchToProps,
)(AddUserComponent) as React.ComponentClass<PublicProps>;
