import * as React from 'react';
import { Button, Layout } from 'twitch-core-ui';
import { Membership } from 'vienna/common/clients/rbacrpc';
import { Modal } from 'vienna/common/components';

export interface PublicProps {
  user: Membership | null;
  onDelete: (user: Membership) => Promise<string>;
}

export interface ReduxDispatchProps {
  closeModal: () => void;
}

type Props = PublicProps & ReduxDispatchProps;

export interface State {
  errorMessage: string;
  success: boolean;
}

export class DeleteUserComponent extends React.Component<Props, State> {
  // Create initial state
  public state: State = {
    success: false,
    errorMessage: '',
  };

  public render() {
    if (!this.props.user) {
      return null;
    }

    return (
      <Modal errorMessage={this.state.errorMessage}>
        <Layout>
          Are you sure you want to delete {this.props.user.firstName} {this.props.user.lastName}?
        </Layout>
        <br />
        <Layout>
          <Button disabled={this.state.success} onClick={this.onDelete}>
            Delete User
          </Button>
          &nbsp;
          <Button onClick={this.onCancel}>{this.state.success ? 'Close' : 'Cancel'}</Button>
        </Layout>
      </Modal>
    );
  }

  private onCancel = () => {
    this.setState({
      errorMessage: '',
      success: false,
    });
    this.props.closeModal();
  };

  private onDelete = async () => {
    if (!this.props.user) {
      return;
    }

    const errorMessage = await this.props.onDelete(this.props.user);
    if (errorMessage === '') {
      this.setState({ success: true });
    } else {
      this.setState({ errorMessage });
    }
  };
}
