import * as React from 'react';
import { Button, ButtonType, Layout } from 'twitch-core-ui';
import { RBAC } from 'vienna/common/clients/rbacClient';
import { ModalShown } from 'vienna/core/actions/modal';
import { PublicProps as DetachExtensionProps } from 'vienna/features/detach-extension/components/detach-extension-modal';

export interface PublicProps {
  companyId: string;
  extensionId: string;
  bIsMonetized: boolean;
  onExtensionsUpdated: () => void;
}

export interface ReduxDispatchProps {
  showDetachExtensionModal: (props: DetachExtensionProps) => ModalShown;
}

type Props = PublicProps & ReduxDispatchProps;

export interface State {}

export class DetachExtensionComponent extends React.Component<Props, State> {
  public state: State = {};

  public render() {
    return (
      <Layout>
        <Button type={ButtonType.Hollow} onClick={this.onClick}>
          Detach
        </Button>
      </Layout>
    );
  }

  private onModalSubmit = async (ownerId: string): Promise<Error | null> => {
    if (this.props.companyId) {
      const detachResponse = await RBAC.detachExtensionFromCompany({
        companyId: this.props.companyId,
        extensionId: this.props.extensionId,
        ownerId: `${ownerId}`,
      });
      if (detachResponse.error) {
        return new Error(detachResponse.error.message);
      }
      this.props.onExtensionsUpdated();
      return null;
    }
    return new Error('Something went wrong');
  };

  private onClick = () => {
    this.props.showDetachExtensionModal({
      onSubmit: this.onModalSubmit,
      companyId: this.props.companyId,
      extensionId: this.props.extensionId,
      bIsMonetized: this.props.bIsMonetized,
    });
  };
}
