import { connect } from 'react-redux';
import { Action, bindActionCreators, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { DetachExtensionModal } from 'vienna/features/detach-extension/components/detach-extension-modal';
import { DetachExtensionComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showDetachExtensionModal: ({ ...props }) => showModal(DetachExtensionModal, props),
    },
    dispatch,
  );
}

export const DetachExtension: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(DetachExtensionComponent);
