import * as React from 'react';
import { CoreText, Interactable, Layout } from 'twitch-core-ui';
import { Game } from 'vienna/features/games-autocomplete/models/game';

export interface PublicProps {
  onClick: (game: Game) => void;
  game: Game;
}

type Props = PublicProps;

export class GameSuggestionComponent extends React.Component<Props> {
  public render() {
    return (
      <Interactable onClick={this.onClick}>
        <Layout padding={1}>
          <CoreText>{this.props.game.name}</CoreText>
        </Layout>
      </Interactable>
    );
  }

  private onClick = (ev: React.MouseEvent<HTMLButtonElement>) => {
    ev.preventDefault();
    this.props.onClick(this.props.game);
  };
}

export const GameSuggestion = GameSuggestionComponent as React.ComponentClass<PublicProps>;
