import * as React from 'react';
import { Tag } from 'twitch-core-ui';
import { Game } from 'vienna/features/games-autocomplete/models/game';

export interface PublicProps {
  onLabelRemove: (game: Game) => void;
  game: Game;
}

type Props = PublicProps;

export class GameTag extends React.Component<Props> {
  public render() {
    return <Tag onClick={this.onClick} label={this.props.game.name} />;
  }

  private onClick = () => {
    this.props.onLabelRemove(this.props.game);
  };
}
