import * as React from 'react';
import { GameSearch } from 'vienna/features/games-autocomplete/components/game-search';
import { Game } from 'vienna/features/games-autocomplete/models/game';

export interface PublicProps {
  multi?: boolean;
  limit?: number;
  onGameSelect: (games: Game[]) => void;
  games: Game[];
  defaultGames?: Game[];
}

export interface State {
  games: Game[];
}

type Props = PublicProps;

/** Suuply a list of games to be autocompleted from */
export class GamesAutocomplete extends React.Component<Props, State> {
  public state: State = {
    games: this.props.games,
  };

  public render() {
    return (
      <GameSearch
        onGameSelect={this.onGameSelect}
        gameSuggestions={this.state.games}
        onInputChange={this.findGames}
        multi={this.props.multi}
        defaultGames={this.props.defaultGames}
      />
    );
  }

  private findGames = async (term: string) => {
    if (!term.length) {
      this.setState({ games: this.props.games });
      return;
    }

    const games = this.props.games.filter(g => g.name.toLowerCase().includes(term.toLowerCase()));
    this.setState({ games });
  };

  private onGameSelect = (games: Game[]) => {
    this.setState({ games: [] });
    if (!games.length) {
      this.setState({ games: this.props.games });
    }
    this.props.onGameSelect(games);
  };
}
