import { connect, Dispatch } from 'react-redux';
import { bindActionCreators } from 'redux';
import { GlobalState } from 'vienna/common/models/global-state';
import { closeModal } from 'vienna/core/actions/modal';
import { ManageDeveloperApplicationComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<GlobalState>): ReduxDispatchProps {
  return bindActionCreators(
    {
      closeModal,
    },
    dispatch,
  );
}

export const ManageDeveloperApplicationModal = connect(
  null,
  mapDispatchToProps,
)(ManageDeveloperApplicationComponent) as React.ComponentClass<PublicProps>;
