import { connect, Dispatch } from 'react-redux';
import { bindActionCreators } from 'redux';
import { GlobalState } from 'vienna/common/models/global-state';
import { closeModal } from 'vienna/core/actions/modal';
import { ManageGameApplicationComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<GlobalState>): ReduxDispatchProps {
  return bindActionCreators(
    {
      closeModal,
    },
    dispatch,
  );
}

export const ManageGameApplicationModal = connect(
  null,
  mapDispatchToProps,
)(ManageGameApplicationComponent) as React.ComponentClass<PublicProps>;
