import * as React from 'react';
import { Layout, Pagination as CorePagination, PaginationMouseEvent } from 'twitch-core-ui';

export interface PublicProps {
  currentPage: number;
  perPage: number;
  total: number;
  onClickIndex: (e: PaginationMouseEvent<HTMLDivElement>) => void;
  onClickNext: () => void;
  onClickPrevious: () => void;
}

class PaginationComponent extends React.Component<PublicProps> {
  public render() {
    const { currentPage, perPage, total, onClickIndex, onClickNext, onClickPrevious } = this.props;

    const totalPages = Math.max(Math.ceil(total / perPage), 1);

    return (
      <Layout margin={{ top: 3, bottom: 1 }}>
        <CorePagination
          currentPage={currentPage}
          totalPages={totalPages}
          onClickIndex={onClickIndex}
          onClickNext={onClickNext}
          onClickPrevious={onClickPrevious}
          nextPageButtonAriaLabel="Next Page"
          previousPageButtonAriaLabel="Previous Page"
        />
      </Layout>
    );
  }
}

export const Pagination: React.ComponentClass<PublicProps> = PaginationComponent;
