import * as React from 'react';
import { Color, CoreText, FontSize, Layout } from 'twitch-core-ui';
import './styles.scss';

export interface PublicProps {
  children: React.ReactNode;
}

type Props = PublicProps;

export const SidebarHeaderComponent = (props: Props) => {
  return (
    <Layout padding={{ top: 2, x: 1, bottom: 0.5 }}>
      <CoreText className="sidebar__item-heading" color={Color.Alt2} fontSize={FontSize.Size5}>
        {props.children}
      </CoreText>
    </Layout>
  );
};

export const SidebarHeader: React.SFC<PublicProps> = SidebarHeaderComponent;
