import * as React from 'react';
import { NavLink } from 'react-router-dom';
import { BorderRadius, Display, FontSize, InjectStyledLayout } from 'twitch-core-ui';
import './styles.scss';

export interface PublicProps {
  children: React.ReactNode;
  to: string;
}

type Props = PublicProps;

const BASE_CLASS = 'sidebar__link';
const ACTIVE_CLASS = 'sidebar__link--active';

export const SidebarNavLinkComponent = (props: Props) => {
  return (
    <InjectStyledLayout
      borderRadius={BorderRadius.Medium}
      display={Display.Block}
      fontSize={FontSize.Size5}
      padding={{ x: 1, y: 0.5 }}
    >
      <NavLink activeClassName={ACTIVE_CLASS} className={BASE_CLASS} exact={false} to={props.to}>
        {props.children}
      </NavLink>
    </InjectStyledLayout>
  );
};

export const SidebarNavLink: React.SFC<PublicProps> = SidebarNavLinkComponent;
