import * as React from 'react';
import { connect } from 'react-redux';
import { RouteComponentProps, withRouter } from 'react-router-dom';
import {
  AlignItems,
  CoreText,
  Display,
  FlexDirection,
  FontSize,
  Layout,
  Overflow,
  StyledLayout,
  TextType,
} from 'twitch-core-ui';
import { GlobalState } from 'vienna/common/models/global-state';
import { SessionUser } from 'vienna/core/models/session-user';
import { getUser } from 'vienna/core/state/session';
import { SidebarHeader } from 'vienna/features/sidebar/components/sidebar-header';
import { SidebarNavLink } from 'vienna/features/sidebar/components/sidebar-nav-link';
import './styles.scss';

export interface PathProps {}

export interface ReduxStateProps {
  user?: SessionUser;
}

type Props = ReduxStateProps & RouteComponentProps<PathProps>;

class SidebarComponent extends React.Component<Props> {
  public render() {
    return (
      <StyledLayout className="sidebar" display={Display.Flex} fontSize={FontSize.Size5} borderRight fullHeight>
        <Layout display={Display.Flex} flexDirection={FlexDirection.Column} fullWidth fullHeight>
          {this.renderSidebarTitle()}
          <Layout overflow={Overflow.Auto}>
            <Layout padding={{ x: 1, y: 0 }}>
              <SidebarHeader>Overview</SidebarHeader>
              <SidebarNavLink to="/overview/companies">Companies</SidebarNavLink>
              <SidebarNavLink to="/overview/extensions">Extensions</SidebarNavLink>

              <SidebarHeader>Review</SidebarHeader>
              <SidebarNavLink to="/review/companies">Companies</SidebarNavLink>
              <SidebarNavLink to="/review/games">Games</SidebarNavLink>
              <SidebarNavLink to="/review/developers">Developers</SidebarNavLink>

              {this.props.user && (
                <>
                  <SidebarHeader>{this.props.user.login}</SidebarHeader>
                  <SidebarNavLink to="/logout">Logout</SidebarNavLink>
                </>
              )}
            </Layout>
          </Layout>
        </Layout>
      </StyledLayout>
    );
  }

  private renderSidebarTitle = () => {
    return (
      <StyledLayout borderBottom>
        <Layout display={Display.Flex} alignItems={AlignItems.Center} padding={1}>
          <Layout padding={{ x: 1 }}>
            <CoreText type={TextType.H4} bold>
              Vienna
            </CoreText>
          </Layout>
        </Layout>
      </StyledLayout>
    );
  };
}

export function mapStateToProps(state: GlobalState): ReduxStateProps {
  return {
    user: getUser(state),
  };
}

export const Sidebar: React.ComponentClass = withRouter(connect(mapStateToProps)(SidebarComponent));
