import * as React from 'react';
import { Button, Layout } from 'twitch-core-ui';
import { RBAC } from 'vienna/common/clients/rbacClient';
import { TransferExtensionRequest } from 'vienna/common/clients/rbacrpc';
import { ModalShown } from 'vienna/core/actions/modal';
import { PublicProps as TransferExtensionProps } from 'vienna/features/transfer-extension/components/transfer-extension-modal';

export interface PublicProps {
  companyId: string;
  onExtensionAdded: () => void;
}

export interface ReduxDispatchProps {
  showTransferExtensionModal: (props: TransferExtensionProps) => ModalShown;
}

type Props = PublicProps & ReduxDispatchProps;

export interface State {}

export class TransferExtensionComponent extends React.Component<Props, State> {
  public state: State = {};

  public render() {
    return (
      <Layout>
        <Button onClick={this.onClick}>Transfer Extension</Button>
      </Layout>
    );
  }

  private onModalSubmit = async (extensionReq: TransferExtensionRequest): Promise<string> => {
    const { error: transferExtensionError } = await RBAC.transferExtensionToCompany(extensionReq);
    if (transferExtensionError) {
      return transferExtensionError.message;
    }
    this.props.onExtensionAdded();
    return '';
  };

  private onClick = () => {
    this.props.showTransferExtensionModal({
      onSubmit: this.onModalSubmit,
      companyId: this.props.companyId,
    });
  };
}
