import { connect } from 'react-redux';
import { Action, bindActionCreators, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { TransferExtensionModal } from 'vienna/features/transfer-extension/components/transfer-extension-modal';
import { PublicProps, ReduxDispatchProps, TransferExtensionComponent } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showTransferExtensionModal: ({ ...props }) => showModal(TransferExtensionModal, props),
    },
    dispatch,
  );
}

export const TransferExtension: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(TransferExtensionComponent);
