import * as React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Action } from 'redux';
import { Dispatch } from 'redux';
import { Button, Layout } from 'twitch-core-ui';
import { closeModal, ModalShown, showModal } from 'vienna/core/actions/modal';
import {
  PublicProps as TransferOwnershipProps,
  TransferOwnershipModal,
} from 'vienna/features/transfer-ownership/components/modal';

interface PublicProps {
  companyId: string;
  onTransfer: () => void;
}

export interface ReduxDispatchProps {
  showTransferOwnershipModal: (props: TransferOwnershipProps) => ModalShown;
  closeModal: () => void;
}

type Props = PublicProps & ReduxDispatchProps;

export class TransferOwnershipBtnComponent extends React.Component<Props> {
  public render() {
    return (
      <Layout>
        <Button onClick={this.onClick}>Transfer Ownership</Button>
      </Layout>
    );
  }

  private onClick = () => {
    this.props.showTransferOwnershipModal({
      onTransfer: this.onTransfer,
      companyId: this.props.companyId,
    });
  };

  private onTransfer = () => {
    this.props.onTransfer();
    this.props.closeModal();
  };
}

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showTransferOwnershipModal: ({ ...props }) => showModal(TransferOwnershipModal, props),
      closeModal,
    },
    dispatch,
  );
}

export const TransferOwnershipBtn: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(TransferOwnershipBtnComponent);
