import { CompanyApplication, DeveloperApplication, Membership } from 'vienna/common/clients/rbacrpc';
import { STRING_TO_REPLACE_SECURE_DATA } from 'vienna/pages/common/constants';

export const wrapMembership = (user: Membership): Membership => {
  if (!user.firstName && !user.lastName && !user.devEmail) {
    return {
      ...user,
      firstName: STRING_TO_REPLACE_SECURE_DATA,
      lastName: STRING_TO_REPLACE_SECURE_DATA,
      devEmail: STRING_TO_REPLACE_SECURE_DATA,
    };
  }
  return user;
};

export const wrapCompanyApplication = (companyApplication: CompanyApplication): CompanyApplication => {
  if (!companyApplication.contactFirstName && !companyApplication.contactLastName && !companyApplication.contactEmail) {
    return {
      ...companyApplication,
      contactFirstName: STRING_TO_REPLACE_SECURE_DATA,
      contactLastName: STRING_TO_REPLACE_SECURE_DATA,
      contactEmail: STRING_TO_REPLACE_SECURE_DATA,
    };
  }
  return companyApplication;
};

export const wrapDevloperApplication = (developerApplication: DeveloperApplication): DeveloperApplication => {
  if (!developerApplication.firstName && !developerApplication.lastName && !developerApplication.email) {
    return {
      ...developerApplication,
      firstName: STRING_TO_REPLACE_SECURE_DATA,
      lastName: STRING_TO_REPLACE_SECURE_DATA,
      email: STRING_TO_REPLACE_SECURE_DATA,
    };
  }
  return developerApplication;
};
