import { RBACMock } from 'vienna/common/clients/rbacrpcMock';
const rbacMock = new RBACMock();
jest.doMock('vienna/common/clients/rbacClient', () => ({
  RBAC: rbacMock,
}));

import { CompanyRow, PublicProps, TestSelectors } from './component';
import { setupShallowTest } from 'vienna/tests/utils/setup';

const companyID = 'asdf';

describe('CompanyApplicationDirectory', () => {
  beforeEach(() => {
    rbacMock.getUsersByCompanyIdMock.mockReturnValue({
      data: {
        id: companyID,
        admins: [],
        managers: [],
        marketers: [],
        developers: [],
      },
    });
    rbacMock.getGamesByCompanyMock.mockReturnValue({
      data: {
        games: [],
        Total: 0,
        company: {
          id: companyID,
          identifier: '',
          cursecompanyId: 0,
          companyname: '',
          url: '',
          type: 0,
          vhsContractsigned: true,
          campaignsenabled: true,
          legacy: false,
          createdat: '',
        },
      },
    });
    rbacMock.getGameApplicationsByCompanyMock.mockReturnValue({
      data: {
        gameapplications: [],
        Total: 0,
      },
    });
    rbacMock.getDeveloperApplicationsMock.mockReturnValueOnce({
      data: {
        developerApplications: [],
        Total: 0,
      },
    });
  });

  it('url without http prefix has http prefix when url is rendered', () => {
    const { wrapper } = setupShallowTest<PublicProps, {}>(
      CompanyRow,
      (): PublicProps => ({
        id: companyID,
        name: 'asdf',
        url: 'asdf.com',
        createdAt: 'asdf',
        type: 1,
      }),
    )();

    const url = wrapper.find({ 'data-test-selector': TestSelectors.COMPANY_URL });
    expect(url.prop('to')).toBe('http://asdf.com');
  });
  it('url with http prefix has prefix not modified', () => {
    const { wrapper } = setupShallowTest<PublicProps, {}>(
      CompanyRow,
      (): PublicProps => ({
        id: companyID,
        name: 'asdf',
        url: 'http://asdf.com',
        createdAt: 'asdf',
        type: 1,
      }),
    )();

    const url = wrapper.find({ 'data-test-selector': TestSelectors.COMPANY_URL });
    expect(url.prop('to')).toBe('http://asdf.com');
  });
  it('url with https prefix has prefix not modified', () => {
    const { wrapper } = setupShallowTest<PublicProps, {}>(
      CompanyRow,
      (): PublicProps => ({
        id: companyID,
        name: 'asdf',
        url: 'https://asdf.com',
        createdAt: 'asdf',
        type: 1,
      }),
    )();

    const url = wrapper.find({ 'data-test-selector': TestSelectors.COMPANY_URL });
    expect(url.prop('to')).toBe('https://asdf.com');
  });
});
