import { connect } from 'react-redux';
import { Action, bindActionCreators, compose, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { withUser } from 'vienna/core/auth/with-user';
import { ManageDeveloperApplicationModal } from 'vienna/features/manage-developer-application';
import { DeveloperApplicationDirectoryComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showManageDeveloperApplicationModal: ({ ...props }) => showModal(ManageDeveloperApplicationModal, props),
    },
    dispatch,
  );
}

export const DeveloperApplicationDirectoryPage: React.ComponentClass<PublicProps> = compose(
  connect(
    null,
    mapDispatchToProps,
  ),
  withUser(),
)(DeveloperApplicationDirectoryComponent);
