import * as Faker from 'faker';
import { KrakenExtension } from 'vienna/common/clients/extensions';
import { Extension } from 'vienna/common/clients/rbacrpc';

function generateExtension(): KrakenExtension {
  return {
    author_name: Faker.random.word(),
    id: Faker.random.uuid(),
    name: Faker.random.word(),
  };
}

export function getExtensions(count: number = 1) {
  return Array(count)
    .fill(count)
    .map(() => generateExtension());
}
