import * as React from 'react';
import { Background, StyledLayout, Table, TableBody, TableHeader, TableHeading } from 'twitch-core-ui';
import { KrakenExtension } from 'vienna/common/clients/extensions';
import { ExtensionRow } from 'vienna/pages/extension-list/components/extension-row';

export interface PublicProps {
  extensions: KrakenExtension[];
}

export const ExtensionTable: React.SFC<PublicProps> = (props: PublicProps) => {
  return (
    <StyledLayout background={Background.Base} margin={{ y: 1 }} elevation={1}>
      <Table>
        <TableHeader>
          <TableHeading label="Extension Name" />
          <TableHeading label="Client ID" />
          <TableHeading label="Author Name" />
          <TableHeading label="Insights" />
        </TableHeader>
        <TableBody>
          {props.extensions.map(extension => (
            <ExtensionRow
              key={extension.id}
              id={extension.id}
              authorName={extension.author_name}
              name={extension.name}
            />
          ))}
        </TableBody>
      </Table>
    </StyledLayout>
  );
};
