import { ExtensionReviewsMock } from 'vienna/common/clients/rbacrpcMock';
import { ErrorMessage } from 'vienna/common/components';

const extensionReviewsMock = new ExtensionReviewsMock();
jest.doMock('vienna/common/clients/rbacClient', () => ({
  ExtensionReviews: extensionReviewsMock,
}));

import { ExtensionReviewComponent } from './component';
import { setupShallowTest } from 'vienna/tests/utils/setup';
import { pause } from 'vienna/tests/utils/pause';
import { TwirpError } from 'vienna/common/clients/twirp';
import { Extension } from 'vienna/common/clients/rbacrpc';

describe('ExtensionReviewComponent', () => {
  it('shows an error if the extension fails to load', async () => {
    extensionReviewsMock.getExtensionMock.mockReturnValue({
      error: new TwirpError({
        msg: 'not found',
        code: '',
        meta: {},
      }),
    });

    const { wrapper } = setupShallowTest(ExtensionReviewComponent)();
    await pause(); // wait for extension to be loaded
    wrapper.update();

    expect(wrapper.find(ErrorMessage).prop('message')).toBe('not found');
  });

  it('shows the extension with buttons to approve or set to pending action if is in review state', async () => {
    const reviewState = 'In Review'; // NOTE: should be "review" but EMS backend is too cool for school
    extensionReviewsMock.getExtensionMock.mockReturnValue({
      data: buildExtensionReviewWithState(reviewState),
    });

    const { wrapper } = setupShallowTest(ExtensionReviewComponent)();
    await pause(); // wait for extension to be loaded
    wrapper.update();

    expect(wrapper.find(ErrorMessage).prop('message')).toBe(undefined); // no error
    expect(wrapper.find({ 'data-test-selector': 'extension-details' })).toExist(); // details
    expect(wrapper.find({ 'data-test-selector': 'action-buttons' })).toExist(); // review buttons
  });

  it('shows the extension but no buttons if state is not review', async () => {
    extensionReviewsMock.getExtensionMock.mockReturnValue({
      data: buildExtensionReviewWithState('pending-action'),
    });

    const { wrapper } = setupShallowTest(ExtensionReviewComponent)();
    await pause(); // wait for extension to be loaded
    wrapper.update();

    expect(wrapper.find(ErrorMessage).prop('message')).toBe(undefined); // no error
    expect(wrapper.find({ 'data-test-selector': 'extension-details' })).toExist(); // details
    expect(wrapper.find({ 'data-test-selector': 'action-buttons' })).not.toExist(); // no review buttons
  });
});

function buildExtensionReviewWithState(state: string): Extension {
  return {
    state: state,
    name: 'Extension Name Foobar',
    id: 'fdafda',
    version: '1.1.1',
    description: 'description',
    summary: 'summary',
    authorName: 'yoloboss',
    transitionLogs: [],
  };
}
