import { connect } from 'react-redux';
import { Action, bindActionCreators, compose, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { withUser } from 'vienna/core/auth/with-user';
import { ManageGameApplicationModal } from 'vienna/features/manage-game-application/components/manage-game-application/container';
import { GameApplicationDirectoryComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showManageGameApplicationModal: ({ ...props }) => showModal(ManageGameApplicationModal, props),
    },
    dispatch,
  );
}

export const GameApplicationDirectoryPage: React.ComponentClass<PublicProps> = compose(
  connect(
    null,
    mapDispatchToProps,
  ),
  withUser(),
)(GameApplicationDirectoryComponent);
