import * as React from 'react';
import { connect } from 'react-redux';
import { Redirect } from 'react-router';
import { config } from 'vienna';
import { GlobalState } from 'vienna/common/models/global-state';
import { home } from 'vienna/core/auth/authenticate-user';
import { SessionUser } from 'vienna/core/models/session-user';
import { authInitialized, getUser } from 'vienna/core/state/session';

interface PublicProps {}

interface ReduxStateProps {
  authInitialized: boolean;
  user?: SessionUser;
}

type Props = PublicProps & ReduxStateProps;

class LoginComponent extends React.Component<Props> {
  public render() {
    if (!this.props.authInitialized) {
      return null;
    }

    if (!this.props.user) {
      window.location.href =
        `https://id.twitch.tv/oauth2/authorize` +
        `?client_id=${encodeURIComponent(config.twitchClientId)}` +
        `&redirect_uri=${encodeURIComponent(config.twitchOauthCallbackURL)}` +
        `&response_type=token` +
        `&force_verify=true`;
      return;
    }

    return <Redirect to={home()} />;
  }
}

export function mapStateToProps(state: GlobalState): ReduxStateProps {
  return {
    authInitialized: authInitialized(state),
    user: getUser(state),
  };
}

export const LoginPage: React.ComponentClass<PublicProps> = connect(mapStateToProps)(LoginComponent);
