import * as React from 'react';
import { Redirect, RouteComponentProps } from 'react-router';
import { Layout } from 'twitch-core-ui';
import { revokeUser } from 'vienna/core/auth/authenticate-user';

export interface PublicProps {}

interface RouteProps {}

type Props = PublicProps & RouteComponentProps<RouteProps>;

export interface State {
  location: string;
}

class LogoutComponent extends React.Component<Props, State> {
  // Create initial state
  public state: State = {
    location: '',
  };

  public async componentDidMount() {
    // Log user out
    const location = await revokeUser();
    this.setState({
      location,
    });
  }

  public render() {
    return this.state.location ? <Redirect to={this.state.location} /> : <Layout>Pending...</Layout>;
  }
}

export const LogoutPage: React.ComponentClass<PublicProps> = LogoutComponent;
