import * as React from 'react';
import { Background, LoadingSpinner, Sorting, StyledLayout, Table, TableHeader, TableHeading } from 'twitch-core-ui';
import { Game } from 'vienna/common/clients/rbacrpc';
import { CompanyGamesTableRow } from 'vienna/pages/manage-company/components/company-games-tab/components/company-games-table-row';

export interface PublicProps {
  company_id: string;
  games: Game[] | null;
  onGameRemoved: () => void;
}

type Props = PublicProps;

class CompanyGamesTabComponent extends React.Component<Props> {
  public render() {
    if (!this.props.games) {
      return <LoadingSpinner />;
    }

    const { games, company_id, onGameRemoved } = this.props;

    return (
      <StyledLayout background={Background.Base} margin={{ y: 1 }} elevation={1}>
        <Table>
          <TableHeader>
            <TableHeading label="Game ID" />
            <TableHeading label="Giantbomb ID" />
            <TableHeading label="Game Name" />
            <TableHeading label="Actions" />
          </TableHeader>

          {games.map(game => (
            <CompanyGamesTableRow key={game.id} game={game} companyId={company_id} onGameRemoved={onGameRemoved} />
          ))}
        </Table>
      </StyledLayout>
    );
  }
}

export const CompanyGamesTab: React.ComponentClass<PublicProps> = CompanyGamesTabComponent;
