import * as React from 'react';
import { connect } from 'react-redux';
import { Action, bindActionCreators, Dispatch } from 'redux';
import { showModal } from 'vienna/core/actions/modal';
import { ActivityLogModal } from 'vienna/features/activity-log';
import { RemoveGameModal } from 'vienna/pages/manage-company/components/company-games-tab/components/remove-game-modal';
import { CompanyGamesTableRowComponent, PublicProps, ReduxDispatchProps } from './component';

function mapDispatchToProps(dispatch: Dispatch<Action>): ReduxDispatchProps {
  return bindActionCreators(
    {
      showActivityLogModal: ({ ...props }) => showModal(ActivityLogModal, props),
      showRemoveGameModal: ({ ...props }) => showModal(RemoveGameModal, props),
    },
    dispatch,
  );
}

export const CompanyGamesTableRow: React.ComponentClass<PublicProps> = connect(
  null,
  mapDispatchToProps,
)(CompanyGamesTableRowComponent);
