import * as React from 'react';
import { Button, ButtonType, Display, FlexDirection, JustifyContent, Layout } from 'twitch-core-ui';
import { Modal } from 'vienna/common/components';

export interface PublicProps {
  gameName: string;
  onDelete: () => Promise<string>;
}

export interface ReduxDispatchProps {
  closeModal: () => void;
}

type Props = PublicProps & ReduxDispatchProps;

export interface State {
  errorMessage: string;
  success: boolean;
}

export class RemoveGameComponent extends React.Component<Props, State> {
  public state: State = {
    success: false,
    errorMessage: '',
  };

  public render() {
    const { gameName } = this.props;

    return (
      <Modal errorMessage={this.state.errorMessage}>
        <Layout>
          Are you sure you want to delete <strong>{gameName}</strong>?
        </Layout>
        <br />
        <Layout display={Display.Flex} flexDirection={FlexDirection.Row} justifyContent={JustifyContent.Center}>
          <Button type={ButtonType.Alert} disabled={this.state.success} onClick={this.onDelete}>
            Remove Game
          </Button>
          <Layout margin={{ left: 0.5 }}>
            <Button onClick={this.onCancel}>{'Cancel'}</Button>
          </Layout>
        </Layout>
      </Modal>
    );
  }

  private onCancel = () => {
    this.setState({
      errorMessage: '',
      success: false,
    });
    this.props.closeModal();
  };

  private onDelete = async () => {
    const { onDelete, closeModal } = this.props;

    const errorMessage = await onDelete();
    if (errorMessage === '') {
      this.setState({ success: true });
      closeModal();
      return;
    } else {
      this.setState({ errorMessage });
    }
  };
}
