import { connect, Dispatch } from 'react-redux';
import { bindActionCreators } from 'redux';
import { GlobalState } from 'vienna/common/models/global-state';
import { closeModal } from 'vienna/core/actions/modal';
import { PublicProps, ReduxDispatchProps, RemoveGameComponent } from './component';

function mapDispatchToProps(dispatch: Dispatch<GlobalState>): ReduxDispatchProps {
  return bindActionCreators(
    {
      closeModal,
    },
    dispatch,
  );
}

export const RemoveGameModal = connect(
  null,
  mapDispatchToProps,
)(RemoveGameComponent) as React.ComponentClass<PublicProps>;
